<?php
/**
 * The Horde_SyncMl_Property class is used to define a single property of a
 * data item supported by the device.
 *
 * The allowed contents of a property can be defined by an enumeration of
 * valid values (ValEnum) or by a DataType/Size combination, or not at all.
 *
 * Copyright 2005-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @author  Karsten Fourmont <karsten@horde.org>
 * @author  Jan Schneider <jan@horde.org>
 * @package SyncMl
 */
class Horde_SyncMl_Property
{
    /**
     * The supported enumerated values of the content type property.
     *
     * The supported values stored in the keys of the hash, e.g. 'PUBLIC' and
     * 'PRIVATE' for a text/calendar 'CLASS' property.
     *
     * @var array
     */
    public $ValEnum;

    /**
     * The datatype of the content type property, e.g. 'chr', 'int', 'bool',
     * etc.
     *
     * @var string
     */
    public $DataType;

    /**
     * The size of the content type property in bytes.
     *
     * @var integer
     */
    public $Size;

    /**
     * The display name of the content type property.
     *
     * @var string
     */
    public $DisplayName;

    /**
     * The supported parameters of the content type property.
     *
     * The parameter name (<ParamName>, e.g. 'WORK' for the text/x-vcard 'TEL'
     * property) are the keys, Horde_SyncMl_PropertyParameter objects are the
     * values.
     *
     * @var array
     */
    public $Params;
}
