<?php
/**
 * Copyright 2006-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @category Horde
 * @package  Perms
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */

/**
 * Maps Kolab_Storage ACL to the Horde permission system.
 *
 * @category Horde
 * @package  Perms
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */
class Horde_Perms_Permission_Kolab_AclIterator implements IteratorAggregate
{
    /**
     * The ACL elements.
     *
     * @var array
     */
    protected $_acl = array();

    /**
     * Constructor.
     *
     * @param array $acl  The folder ACL as provided by the driver.
     */
    public function __construct(array $acl)
    {
        foreach ($acl as $user => $rights) {
            if (substr($user, 0, 6) == 'group:') {
                $this->_acl[] = new Horde_Perms_Permission_Kolab_Acl_Group(
                    $rights, substr($user, 6)
                );
            } elseif ($user == 'anyone' || $user == 'anonymous'){
                $class = 'Horde_Perms_Permission_Kolab_Acl_' . Horde_String::ucfirst($user);
                $this->_acl[] = new $class(
                    $rights
                );
            } else {
                $this->_acl[] = new Horde_Perms_Permission_Kolab_Acl_User(
                    $rights, $user
                );
            }
        }
    }

    public function getIterator()
    {
        return new ArrayIterator($this->_acl);
    }
}
