<?php
/**
 * Copyright 2011-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @category Horde
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @package  Pear
 */

/**
 * Horde_Pear_Package_Contents_Role:: defines role handlers for package.xml
 * filelists.
 *
 * @author    Gunnar Wrobel <wrobel@pardus.de>
 * @category  Horde
 * @copyright 2011-2017 Horde LLC
 * @license   http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @package   Pear
 */
interface Horde_Pear_Package_Contents_Role
{
    /**
     * Tell which role the specified file has.
     *
     * @param string $file The file name.
     *
     * @return string The role of the file.
     */
    public function getRole($file);

    /**
     * Tell which replacement tasks are required for the specified file.
     *
     * @param string $file The file path inside the component.
     * @param string $root The filesystem root of the component.
     *
     * @return array A list of <tasks:replace> attribute hashes.
     */
    public function getReplace($file, $root);
}
