<?php
/**
 * Copyright 2011-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @category Horde
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @package  Pear
 */

/**
 * Horde_Pear_Package_Contents_InstallAs_HordeApplication:: determines install
 * locations for Horde applications.
 *
 * @author    Gunnar Wrobel <wrobel@pardus.de>
 * @category  Horde
 * @copyright 2011-2017 Horde LLC
 * @license   http://www.horde.org/licenses/lgpl21 LGPL 2.1
 * @package   Pear
 */
class Horde_Pear_Package_Contents_InstallAs_HordeApplication
implements Horde_Pear_Package_Contents_InstallAs
{
    /**
     * The package type.
     *
     * @var Horde_Pear_Package_Type
     */
    private $_type;

    /**
     * Constructor.
     *
     * @param Horde_Pear_Package_Type $type The package type.
     */
    public function __construct(Horde_Pear_Package_Type $type)
    {
        $this->_type = $type;
    }

    /**
     * Tell which location the specified file should be installed to.
     *
     * @param string $file     The file name.
     * @param string $package  The package name.
     *
     * @return string The install location for the file.
     */
    public function getInstallAs($file, $package)
    {
        $elements = explode('/', substr($file, 1));
        $basedir = array_shift($elements);
        switch ($basedir) {
        case 'bin':
        case 'doc':
        case 'docs':
        case 'test':
            return join('/', $elements);
        case 'COPYING':
        case 'LICENSE':
        case 'README':
        case 'README.md':
        case 'README.rst':
            return substr($file, 1);
        default:
            return $this->_type->getName() . $file;
        }
    }
}
