<?php
/**
 * A Horde_Injector:: based factory for creating Horde_View objects.
 *
 * Copyright 2010-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @category Horde
 * @package  Core
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */

/**
 * A Horde_Injector:: based factory for creating Horde_View objects.
 *
 * Copyright 2010-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (LGPL). If you
 * did not receive this file, see http://www.horde.org/licenses/lgpl21.
 *
 * @category Horde
 * @package  Core
 * @author   Chuck Hagenbuch <chuck@horde.org>
 * @license  http://www.horde.org/licenses/lgpl21 LGPL 2.1
 */
class Horde_Core_Factory_View extends Horde_Core_Factory_Injector
{
    public function create(Horde_Injector $injector)
    {
        $registry = $injector->getInstance('Horde_Registry');
        $view = new Horde_View(array('templatePath' => $registry->get('templates', $registry->getApp())));
        $view->addHelper('Tag');
        $view->addHelper('Text');
        return $view;
    }
}
