<?php
/**
 * Copyright 2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsd.
 *
 * @author   Jan Schneider <jan@horde.org>
 * @category Horde
 * @license  http://www.horde.org/licenses/bsd BSD
 * @package  Backup
 */

namespace Horde\Backup;

/**
 * An application's backup for a single user.
 *
 * @author    Jan Schneider <jan@horde.org>
 * @category  Horde
 * @copyright 2017 Horde LLC
 * @license   http://www.horde.org/licenses/bsd BSD
 * @package   Backup
 */
class User
{
    /**
     * The user name.
     *
     * @var string
     */
    public $user;

    /**
     * The collections of backup objects.
     *
     * @var \Horde\Backup\Collection[]
     */
    public $collections = array();

    /**
     * Constructor.
     *
     * @param string $user  A user name.
     */
    public function __construct($user = null)
    {
        $this->user = $user;
    }
}
