<?php
/**
 * Copyright 2011-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (GPLv2). If
 * you did not receive this file, see http://www.horde.org/licenses/gpl
 *
 * @category Horde
 * @package  Wicked
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @link     http://www.horde.org/apps/wicked
 * @license  http://www.horde.org/licenses/gpl GNU General Public License, version 2
 */

/**
 * Renders collected links for a Wiki page.
 *
 * @category Horde
 * @package  Wicked
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @link     http://www.horde.org/apps/wicked
 * @license  http://www.horde.org/licenses/gpl GNU General Public License, version 2
 */
class Text_Wiki_Render_Rst_Links
{
    public static function append()
    {
        // Don't include Text_Wiki_Render_Rst_Freelink2 because it extends
        // Text_Wiki_Render_Rst_Wikilink.
        $result = '';
        $links = array_merge(
            Text_Wiki_Render_Rst_Interwiki::$paragraph_links,
            Text_Wiki_Render_Rst_Phplookup::$paragraph_links,
            Text_Wiki_Render_Rst_Url::$paragraph_links,
            Text_Wiki_Render_Rst_Wikilink::$paragraph_links
        );
        if (!empty($links)) {
            $result .= "\n";
            foreach ($links as $link) {
                $result .= "\n" . $link ;
            }
            Text_Wiki_Render_Rst_Interwiki::$paragraph_links = array();
            Text_Wiki_Render_Rst_Phplookup::$paragraph_links = array();
            Text_Wiki_Render_Rst_Url::$paragraph_links = array();
            Text_Wiki_Render_Rst_Wikilink::$paragraph_links = array();
        }
        return $result;
    }
}
