<?php
/**
 * The Sesha_Entity_PropertyMapper class contains all functions related to handling
 * property mapping in Sesha.
 *
 * Copyright 2012-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (GPL). If you
 * did not receive this file, see http://www.horde.org/licenses/gpl.
 *
 * @author   Ralf Lang <lang@b1-systems.de>
 * @category Horde
 * @package  Sesha
 * @license  http://www.horde.org/licenses/gpl GPL
 */


/**
 * The Sesha_Entity_PropertyMapper class contains all functions related to handling
 * property mapping in Sesha.
 *
 * Copyright 2012-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (GPL). If you
 * did not receive this file, see http://www.horde.org/licenses/gpl.
 *
 * @author   Ralf Lang <lang@b1-systems.de>
 * @category Horde
 * @package  Sesha
 * @license  http://www.horde.org/licenses/gpl GPL
 */
class Sesha_Entity_PropertyMapper extends Horde_Rdo_Mapper
{
    /**
     * Inflector doesn't support Horde-style tables yet
     * @var string
     * @access protected
     */
    protected $_table = 'sesha_properties';

    /**
     * Relationships loaded on-demand
     * @var array
     * @access protected
     */
    protected $_lazyRelationships = array(
       'categories' => array('type' => Horde_Rdo::MANY_TO_MANY,
                        'mapper' => 'Sesha_Entity_CategoryMapper',
                        'through' => 'sesha_relations'),
       'values' => array('type' => Horde_Rdo::ONE_TO_MANY,
                        'mapper' => 'Sesha_Entity_ValueMapper',
                        'foreignKey' => 'property_id',
                        ),
        );

    /**
     * Creates a property definition in the backend.
     * This wraps folding of the 'parameters' structure 
     *
     * @param array $property  An array with the property definition.
     *                         Keys may be
     *                          property_id Integer (autogenerated)
     *                          property    string The property name
     *                          datatype    string The property type
     *                          parameters  mixed Type definition parameters will be serialized
     *                          unit        string The unit to display
     *                          description string
     *                          priority    integer
     *
     * @return Sesha_Entity_Property  The property created.
     */
    public function create(array $property)
    {
        if (!is_string($property['parameters'])) {
            $property['parameters'] = serialize($property['parameters']);
        }
        if (array_key_exists('property_id', $property) &&
            $property['property_id'] == null)
            unset($property['property_id']);
        return parent::create($property);
    }

    /**
     * Updates a record in the backend. $object can be either a
     * primary key or an Rdo object. If $object is an Rdo instance
     * then $fields will be ignored as values will be pulled from the
     * object.
     *
     * @param string|Rdo $object The Rdo instance or unique id to update.
     * @param array $fields If passing a unique id, the array of field properties
     *                      to set for $object.
     *
     * @return integer Number of objects updated.
     */

    /**
     * Deletes a property definition from the backend. $object can be either a
     * primary key, an Rdo_Query object, or a Sesha_Entity_Property object.
     * This also cleans up attachment attributes of this property type and category links
     *
     * @param string|Sesha_Entity_Property|Horde_Rdo_Query $object The Rdo object,
     * Horde_Rdo_Query, or unique id to delete.
     *
     * @return integer Number of objects deleted.
     */
    public function delete($object)
    {
        if (!($object instanceof Sesha_Entity_Property)) {
            $object = $this->findOne($object);
        }
        foreach ($object->values as $value) {
            $value->delete();
        }
        $object->removeRelation('categories');
        return parent::delete($object);
    }
}

