<?php
/**
 * See horde/config/prefs.php for documentation on the structure of this file.
 *
 * IMPORTANT: DO NOT EDIT THIS FILE! DO NOT COPY prefs.php TO prefs.local.php!
 * Local overrides ONLY MUST be placed in prefs.local.php or prefs.d/.
 * If the 'vhosts' setting has been enabled in Horde's configuration, you can
 * use prefs-servername.php.
 */

// This preference group will only be displayed if the configured script
// driver can create script files.
$prefGroups['script'] = array(
    'column' => _("Other Preferences"),
    'label' => _("Script Updating"),
    'desc' => _("Preferences about script updating."),
    'members' => array('auto_update'),
    'suppress' => function() {
        return !$GLOBALS['injector']->getInstance('Ingo_Factory_Script')
            ->hasFeature('script_file');
    }
);

// Automatically update the script?
$_prefs['auto_update'] = array(
    'value' => 1,
    'locked' => false,
    'type' => 'checkbox',
    'desc' => _("Automatically activate the script after each change?")
);

// End script preferences



// The following preferences are only used for script drivers that can do
// on-demand filtering.

// Show detailed filter status messages?
// a value of 0 = no, 1 = yes
$_prefs['show_filter_msg'] = array(
    'value' => 1,
    'locked' => false,
    'type' => 'implicit'
);

// Only filter [un]seen messages?
// Values: 0, Ingo::FILTER_UNSEEN, Ingo::FILTER_SEEN
$_prefs['filter_seen'] = array(
    'value' => 0,
    'locked' => false,
    'type' => 'implicit'
);

// End on-demand filtering preferences



// The following preference are only used if using the 'prefs' storage driver.

// Filter rules.
$_prefs['rules'] = array();

// Blacklist.
$_prefs['blacklist'] = array(
    // Lock this preference to disable blacklists.
    'locked' => false
);

// Whitelist.
$_prefs['whitelist'] = array(
    // Lock this preference to disable whitelists.
    'locked' => false
);

// Vacation notices.
$_prefs['vacation'] = array(
    // Lock this preference to disable vacation notices.
    'locked' => false
);

// Forwarding.
$_prefs['forward'] = array(
    // Lock this preference to disable forwarding.
    'locked' => false
);

// Spam rule.
$_prefs['spam'] = array(
    // Lock this preference to disable the spam rule.
    'locked' => false
);

// End preferences storage driver entries
